/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.handler;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;
import vazkii.quark.base.handler.GeneralConfig;

public class SimilarBlockTypeHandler {
    public static List<String> getBasicShulkerBoxes() {
        return ImmutableSet.of((Object)Blocks.field_190977_dl, (Object)Blocks.field_190978_dm, (Object)Blocks.field_190979_dn, (Object)Blocks.field_190980_do, (Object)Blocks.field_190981_dp, (Object)Blocks.field_190982_dq, (Object[])new Block[]{Blocks.field_190983_dr, Blocks.field_190984_ds, Blocks.field_196875_ie, Blocks.field_190986_du, Blocks.field_190987_dv, Blocks.field_190988_dw, Blocks.field_190989_dx, Blocks.field_190990_dy, Blocks.field_190991_dz, Blocks.field_190975_dA}).stream().map(IForgeRegistryEntry::getRegistryName).map(Objects::toString).collect(Collectors.toList());
    }

    public static boolean isShulkerBox(ItemStack stack) {
        return SimilarBlockTypeHandler.isShulkerBox(stack.func_77973_b().getRegistryName()) && !stack.func_190926_b() && stack.func_77976_d() == 1;
    }

    public static boolean isShulkerBox(ResourceLocation loc) {
        if (loc == null) {
            return false;
        }
        String locStr = loc.toString();
        if (GeneralConfig.shulkerBoxes.contains(locStr)) {
            return true;
        }
        return GeneralConfig.interpretShulkerBoxLikeBlocks && locStr.contains("shulker_box");
    }
}

